#version 430

layout(points)       in;
layout(points)       out;
layout(max_vertices = 1)  out;

layout (location = 0) in vec4      vs_PositionType[];
layout (location = 1) in vec4      vs_VelocityAge[];
layout (location = 2) in vec4     vs_AuxVecOne[];


layout (location = 0) out vec4     gs_PositionType;
layout (location = 1) out vec4     gs_VelocityAge;
layout (location = 2) out vec4     gs_AuxVecOne;

uniform float   u_SunParticleAlphaLifetime = 5.0f;
uniform float   u_SunParticleBetaLifetime = 5.0f;
uniform float   u_ShuttleParticleLifetime = 1.0f;

uniform float   u_ExplosionParticleAlphaLifetime = 4.0f;
uniform float   u_ExplosionParticleBetaLifetime = 2.0f;
uniform float   u_ExplosionParticleGammaLifetime = 1.0f;

uniform float   u_DoodadParticleVentLifetime = 2.0f;

uniform float   u_BurgerParticleLifetime = 2.0f;
uniform float   u_CarrierHyperSpaceParticleLifetime = 2.0f;
uniform float u_ReactorLightningBoltParticleLifetime = 0.4f;
uniform float   u_FireworksRocketParticleLifetime = 1.0f;
uniform float   u_FireworksExplosionParticleLifetime = 1.5f;


//------------------------------------------------------------------------------
//
void main(){
	float ParticleLifetime;
	switch(int(vs_PositionType[0].w)){	
		case(1):
			ParticleLifetime = u_SunParticleAlphaLifetime;
			break;
		case(2):
			ParticleLifetime = u_SunParticleBetaLifetime;
			break;
		case(3):
			ParticleLifetime = u_ShuttleParticleLifetime;
			break;
		case(4):
			ParticleLifetime = u_ExplosionParticleAlphaLifetime;
			break;
		case(5):
			ParticleLifetime = u_ExplosionParticleBetaLifetime;
			break;
		case(6):
			ParticleLifetime = u_ExplosionParticleGammaLifetime;
			break;
		case(7):
			ParticleLifetime = u_DoodadParticleVentLifetime;
			break;
		case(8):
			ParticleLifetime = u_BurgerParticleLifetime;
			break;
		case(9):
			ParticleLifetime = u_CarrierHyperSpaceParticleLifetime;
			break;
		case(11):
			ParticleLifetime = u_ReactorLightningBoltParticleLifetime;
			break;
		case(12):
			ParticleLifetime = u_FireworksRocketParticleLifetime;
			break;
		case(13):
			ParticleLifetime = u_FireworksExplosionParticleLifetime;
			break;

		default: 
			ParticleLifetime = 0;
			break;
	}
  if (vs_VelocityAge[0].w < ParticleLifetime)
  {
		gs_PositionType = vs_PositionType[0];
    gs_VelocityAge = vs_VelocityAge[0];
		gs_AuxVecOne = vs_AuxVecOne[0];

    EmitVertex();
    EndPrimitive();
  }
}